# -*- coding: utf-8 -*-
import random, os, re

class Details:
	# default output file extension
	EXT_CONVD = '.convd'
	#(.xml(.convd)?)? inverted; group 4 is the rest (inverted as well)
	p_revxml = re.compile('((%s)?(lmx\\.))?(.*)' % EXT_CONVD[::-1].replace('.', '\\.'), re.IGNORECASE)
	
	SELECT_DISAMB = [
		('random', lambda seq: int(random.random() * len(seq)))
	]
	
	TEXT_ID = [
		('xname', lambda path: Details.p_revxml.match(os.path.basename(path)[::-1]).group(4)[::-1]), # get the last part of the filename without .xml.convd
		('name', lambda path: os.path.basename(path)), # get the last part of the filename
		('pl', lambda anything: 'Opl.') # use 'Opl.' for Polish as in 'Oen.' for English or 'Obg.' for Bulgarian
	]
	
	
	def __init__(self, options):
		self.select = dict(Details.SELECT_DISAMB)[options.select]
		self.get_text_id = dict(Details.TEXT_ID)[options.textid]
		self.clean_lex = options.clean_lex
		self.walk_dir = options.walk_dir

